unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;


const cMAX = 5000;

type
  RPojemnik = packed record
     nazwisko : String[25];
     imie     : String[15];
  end;


  TMainForm = class(TForm)
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Memo1: TMemo;
    Memo2: TMemo;
    Splitter1: TSplitter;
    procedure FormShow(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);

  private

  public
    procedure Demo();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.BitBtn1Click(Sender: TObject);
begin
	Close();
end;

procedure TMainForm.BitBtn2Click(Sender: TObject);
begin
	Demo();
end;

procedure TMainForm.FormShow(Sender: TObject);
var
	szer : Integer;

begin
	szer := Screen.Width div 2;

   Memo1.Width := szer;
   Memo2.Align := alClient;

   Memo1.Clear();
   Memo2.Clear();
end;

procedure TMainForm.Demo();
var
	lp       : Integer;
   nazwisko : String;
   imie     : String;
   iRecs    : LongInt;
   strumien : TMemoryStream;
   Rec      : RPojemnik;
   fn       : String;

begin
   Memo1.Clear();
   Memo1.Visible := false;

	strumien := TMemoryStream.Create();

	// zapis do strumienia
   Memo1.Lines.Add('Dane zapisane do strumienia');
   Memo1.Lines.Add('');

   for lp := 1 to cMAX do
   begin
      nazwisko := 'nazwisko' + IntToStr(lp);
      imie     := 'imie'     + IntToStr(lp);

   	Rec.nazwisko := nazwisko;
   	Rec.imie     := imie;

      strumien.Write(Rec, sizeof(Rec));

      Memo1.Lines.Add(nazwisko + ' ' + imie);
   end;
   Memo1.Visible := true;

   // zapis caego strumienia na dysk
   fn := ExtractFilePath(Application.ExeName) + 'TEST.REC';
   strumien.SaveToFile(fn);


	// strumien.LoadFromStream(fn);
	// zamiast
	// strumien.LoadFromStream(fn);
   //
   Memo2.Clear();
   Memo2.Visible := false;
   Memo2.Lines.Add('Dane odczytane ze strumienia');
   Memo2.Lines.Add('');

	iRecs := strumien.Size div sizeof(RPojemnik);
	// ustaw sie na pocztku strumienia
   strumien.Seek(0, soFromBeginning);

   for lp := 1 to iRecs do
   begin
      strumien.Read(Rec, sizeof(Rec));
      nazwisko := Rec.nazwisko;
      imie     := Rec.imie;

      Memo2.Lines.Add(nazwisko + ' ' + imie);
   end;
   Memo2.Visible := true;

	if Assigned(strumien) then
   begin
	   FreeAndNil(strumien);
   end;
end;

end.

